/*
 * pgpMakePKE.h -- Make a Public Key Encrypted packet from a pubkey and a
 * session key.
 *
 * This is a PRIVATE header file, for use only within the PGP Library.
 * You should not be using these functions in an application.
 *
 * $Id: pgpMakePKE.h,v 1.5 2001/01/25 22:11:16 jeffc Exp $
 */

#ifndef Included_pgpMakePKE_h
#define Included_pgpMakePKE_h

#include <stddef.h>	/* For size_t */

#include "pgpUsuals.h"	/* For PGPByte and PgpVersion */
#include "pgpContext.h"

PGP_BEGIN_C_DECLARATIONS

/*
 * Allocate and return a buffer to hold the ESK packet in *buf, *len.
 */
PGPError
makePke (PGPContextRef context, PGPKeyDBObj const *key,
	PGPByte const *symkey, unsigned symkeylen,
	PgpVersion version, PGPByte **buf, PGPSize *len );

PGP_END_C_DECLARATIONS

#endif /* Included_pgpMakePKE_h */
